chrome.runtime.onMessage.addListener((req) => {
  if (req.action === "run_instant_publish") {
    startInstantPublish();
  }
});

async function startInstantPublish() {
  const tabs = await chrome.tabs.query({ url: "*://*.lovable.dev/projects/*" });

  tabs.forEach(async (tab, index) => {
    // Pequeno delay de 150ms entre abas apenas para o navegador não travar o foco
    setTimeout(async () => {
      await chrome.tabs.update(tab.id, { active: true });
      
      chrome.scripting.executeScript({
        target: { tabId: tab.id },
        func: instantClickSequence
      });
    }, index * 150);
  });
}

function instantClickSequence() {
  const fastClick = (el) => {
    const r = el.getBoundingClientRect();
    const opts = {
      bubbles: true, cancelable: true, view: window,
      clientX: r.left + r.width / 2, clientY: r.top + r.height / 2
    };
    el.dispatchEvent(new PointerEvent('pointerdown', opts));
    el.dispatchEvent(new MouseEvent('mousedown', opts));
    el.dispatchEvent(new MouseEvent('mouseup', opts));
    el.dispatchEvent(new MouseEvent('click', opts));
  };

  // 1. Clica no Publish do Topo (Botão da sua 1ª foto)
  const btnHeader = [...document.querySelectorAll('button')].find(b => 
    b.textContent.trim() === 'Publish' && b.getBoundingClientRect().top < 100
  );

  if (btnHeader) {
    fastClick(btnHeader);

    // 2. Tenta clicar no botão do modal (Botão da sua 2ª foto)
    // Ele tenta a cada 100ms até encontrar ou completar 3 segundos
    let attempts = 0;
    const interval = setInterval(() => {
      const btnModal = [...document.querySelectorAll('button')].find(b => {
        const txt = b.textContent.trim();
        const rect = b.getBoundingClientRect();
        return txt === 'Publish' && rect.top > 100 && b.offsetWidth > 0;
      });

      if (btnModal) {
        fastClick(btnModal);
        clearInterval(interval);
      }

      if (++attempts > 30) clearInterval(interval);
    }, 100);
  }
}